/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.handlers.effects;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.client.effects.EntityEffect;
import org.orecruncher.dsurround.client.effects.IEntityEffectFactory;
import org.orecruncher.dsurround.client.effects.IEntityEffectFactoryFilter;
import org.orecruncher.dsurround.client.effects.IEntityEffectHandlerState;
import org.orecruncher.dsurround.client.fx.particle.ParticleTextPopOff;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.lib.Color;
import org.orecruncher.lib.Translations;
import org.orecruncher.lib.math.MathStuff;
import org.orecruncher.lib.random.XorShiftRandom;

@SideOnly(value=Side.CLIENT)
public class EntityHealthPopoffEffect
extends EntityEffect {
    private static final Color CRITICAL_TEXT_COLOR = Color.MC_GOLD;
    private static final Color HEAL_TEXT_COLOR = Color.MC_GREEN;
    private static final Color DAMAGE_TEXT_COLOR = Color.MC_RED;
    private static final Translations xlate = new Translations();
    private static final int CRITWORD_COUNT = 85;
    private static final String CRITWORD_PREFIX = "critword.";
    protected float lastHealth;
    public static final IEntityEffectFactoryFilter DEFAULT_FILTER;

    private String getPowerWord() {
        int id = XorShiftRandom.current().nextInt(85);
        return xlate.loadString(CRITWORD_PREFIX + id) + "!";
    }

    @Override
    public void initialize(@Nonnull IEntityEffectHandlerState state) {
        super.initialize(state);
        this.getState().subject().ifPresent(e -> {
            this.lastHealth = ((EntityLivingBase)e).func_110143_aJ();
        });
    }

    @Override
    @Nonnull
    public String name() {
        return "Health Tracker";
    }

    @Override
    public boolean receiveLastCall() {
        return true;
    }

    @Override
    public void update(@Nonnull Entity subject) {
        if (!ModOptions.effects.enableDamagePopoffs) {
            return;
        }
        EntityLivingBase entity = (EntityLivingBase)subject;
        if (this.lastHealth != entity.func_110143_aJ()) {
            int adjustment = MathHelper.func_76123_f((float)(entity.func_110143_aJ() - this.lastHealth));
            this.lastHealth = entity.func_110143_aJ();
            if (!EnvironStateHandler.EnvironState.isPlayer(subject) || !this.isFirstPersonView()) {
                ParticleTextPopOff particle;
                int delta = Math.max(1, MathStuff.abs((int)adjustment));
                int criticalAmount = (int)(entity.func_110138_aP() / 2.5f);
                AxisAlignedBB bb = entity.func_174813_aQ();
                double posX = entity.field_70165_t;
                double posY = bb.field_72337_e + 0.5;
                double posZ = entity.field_70161_v;
                String text = String.valueOf(delta);
                Color color = adjustment > 0 ? HEAL_TEXT_COLOR : DAMAGE_TEXT_COLOR;
                World world = EnvironStateHandler.EnvironState.getWorld();
                if (ModOptions.effects.showCritWords && adjustment < 0 && delta >= criticalAmount) {
                    particle = new ParticleTextPopOff(world, this.getPowerWord(), CRITICAL_TEXT_COLOR, posX, posY + 0.5, posZ);
                    this.getState().addParticle(particle);
                }
                particle = new ParticleTextPopOff(world, text, color, posX, posY, posZ);
                this.getState().addParticle(particle);
            }
        }
    }

    static {
        xlate.load("/assets/dsurround/dsurround/data/critwords/", new String[0]);
        DEFAULT_FILTER = (e, eei) -> e instanceof EntityLivingBase;
    }

    public static class Factory
    implements IEntityEffectFactory {
        @Override
        @Nonnull
        public List<EntityEffect> create(@Nonnull Entity entity) {
            return ImmutableList.of((Object)new EntityHealthPopoffEffect());
        }
    }
}

